<?php

/**
 * Plugin Name: Checkout WooCommerce Personalizado - SmmLoja
 * Description: Plugin Checkout WooCommerce Personalizado - SmmLoja para comprar seguidores no Instagram e outros produtos digitais.
 * Version: 2.0
 * Requires Plugins: woocommerce, customer-reviews-woocommerce
 */


if (!defined('ABSPATH')) {
    exit; // Sair se acessado diretamente
}

// Definir constante para o caminho do plugin (se ainda não existir)
if ( ! defined( 'UPGRAM_PLUGIN_PATH' ) ) {
    define( 'UPGRAM_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
}

define('UPGRAM_PATH', plugin_dir_path(__FILE__));
define('UPGRAM_URL', plugin_dir_url(__FILE__));
define('UPGRAM_VERSION', '1.26.0');
define('INSTAGRAM_API_URL', 'https://social-api4.p.rapidapi.com');
define('TIKTOK_API_URL', 'https://tiktok-video-downloader-api.p.rapidapi.com');


require_once UPGRAM_PATH . 'admin/settings-page.php';
require_once UPGRAM_PATH . 'admin/order-status-page.php';
require_once UPGRAM_PATH . 'admin/provider-services-page.php';
require_once UPGRAM_PATH . 'includes/actions.php';
require_once UPGRAM_PATH . 'includes/instagram.php';
require_once UPGRAM_PATH . 'includes/woocommerce.php';
require_once UPGRAM_PATH . 'includes/downloader.php';
require_once UPGRAM_PATH . 'includes/free-followers.php';
require_once UPGRAM_PATH . 'includes/free-views.php';
require_once UPGRAM_PATH . 'includes/free-likes.php';
require_once UPGRAM_PATH . 'includes/order-status-checker.php';
require_once UPGRAM_PATH . 'includes/order-retry-sender.php';
require_once UPGRAM_PATH . 'includes/action-scheduler-cleanup.php';
require_once UPGRAM_PATH . 'includes/license-security.php';
require_once UPGRAM_PATH . 'includes/license-checker.php';
require_once UPGRAM_PATH . 'includes/license-validator-advanced.php';
require_once UPGRAM_PATH . 'includes/license-validation-trigger.php';
require_once UPGRAM_PATH . 'includes/product-faq.php';
require_once UPGRAM_PATH . 'includes/product-important-info.php';
require_once UPGRAM_PATH . 'includes/product-ia-subtitles.php';
require_once UPGRAM_PATH . 'includes/chatgpt-api.php';
require_once UPGRAM_PATH . 'includes/class-upgram-product-page.php';
require_once UPGRAM_PATH . 'public/shortcodes.php';
// Carregar classe de produto como página inicial apenas se o arquivo existir
if (file_exists(UPGRAM_PATH . 'includes/class-smm-home-product-front-page.php')) {
    require_once UPGRAM_PATH . 'includes/class-smm-home-product-front-page.php';
}

// Assistente de Conteúdo com IA
require_once UPGRAM_PATH . 'includes/class-upgram-ia-content-generator.php';
require_once UPGRAM_PATH . 'includes/class-upgram-ia-metabox.php';
require_once UPGRAM_PATH . 'includes/class-upgram-ia-rest-api.php';
require_once UPGRAM_PATH . 'admin/ia-content-settings-page.php';

// Listagem de Blog
require_once UPGRAM_PATH . 'includes/class-upgram-blog-listing.php';

// Otimizador de Performance
require_once UPGRAM_PATH . 'includes/class-upgram-optimizer.php';

// Inicializar Assistente de Conteúdo com IA
add_action('init', function() {
    Upgram_IA_Metabox::init();
    Upgram_IA_REST_API::init();
});

// Inicializar Listagem de Blog
add_action('plugins_loaded', function() {
    if (class_exists('Upgram_Blog_Listing')) {
        Upgram_Blog_Listing::get_instance();
    }
}, 10);

// Inicializar Otimizador de Performance
add_action('plugins_loaded', function() {
    if (class_exists('Upgram_Optimizer')) {
        Upgram_Optimizer::get_instance();
    }
}, 5);

// Inicializar funcionalidade de produto como página inicial
// Usar prioridade baixa para garantir que outros plugins estejam carregados primeiro
add_action('plugins_loaded', function() {
    // Verificar se a classe foi carregada corretamente
    if (!class_exists('SMM_Home_Product_Front_Page')) {
        return;
    }
    
    try {
        // Usar get_instance() diretamente, que já inicializa a classe
        SMM_Home_Product_Front_Page::get_instance();
    } catch (Exception $e) {
        error_log('SMM Home Product: Erro ao inicializar - ' . $e->getMessage());
    } catch (Error $e) {
        error_log('SMM Home Product: Erro fatal ao inicializar - ' . $e->getMessage());
    } catch (Throwable $e) {
        // Capturar qualquer outro tipo de erro
        error_log('SMM Home Product: Erro ao inicializar - ' . $e->getMessage());
    }
}, 20);

/**
 * Gerar arquivos minificados quando a opção for ativada ou atualizada
 */
function upgram_generate_minified_on_option_update($option_name, $old_value, $value) {
    if ($option_name === 'upgram_use_minified_files') {
        // Converter valor para boolean
        $old_bool = (bool) $old_value;
        $new_bool = (bool) $value;
        
        // Se a opção foi ativada (mudou de false para true), gerar arquivos minificados
        if ($new_bool == true && $old_bool == false) {
            // Usar transiente para marcar que precisa gerar arquivos
            set_transient('upgram_generate_minified_files', true, 60);
            
            // Tentar gerar imediatamente
            if (!function_exists('upgram_generate_minified_files')) {
                require_once UPGRAM_PATH . 'includes/helpers.php';
            }
            
            if (function_exists('upgram_generate_minified_files')) {
                try {
                    $generated = upgram_generate_minified_files();
                    if (!empty($generated)) {
                        error_log('Upgram: Arquivos minificados gerados via updated_option: ' . implode(', ', $generated));
                    }
                } catch (Exception $e) {
                    error_log('Upgram: Erro ao gerar arquivos minificados: ' . $e->getMessage());
                }
            }
        }
    }
}
add_action('updated_option', 'upgram_generate_minified_on_option_update', 10, 3);

/**
 * Gerar arquivos minificados após salvar as configurações
 */
function upgram_generate_minified_after_settings_save() {
    // Verificar se estamos salvando as configurações do upgram
    if (isset($_POST['option_page']) && $_POST['option_page'] === 'upgram') {
        // Verificar se a opção de minificação foi marcada
        $use_minified = isset($_POST['upgram_use_minified_files']) && $_POST['upgram_use_minified_files'] == '1';
        
        if ($use_minified) {
            // Verificar se a opção anterior era false
            $old_value = get_option('upgram_use_minified_files', false);
            
            // Se estava desativado e agora está ativado, gerar arquivos
            if (!$old_value) {
                // Marcar que precisa gerar arquivos
                set_transient('upgram_generate_minified_files', true, 60);
                
                // Tentar gerar imediatamente também
                if (function_exists('upgram_generate_minified_files')) {
                    upgram_generate_minified_files();
                } elseif (file_exists(UPGRAM_PATH . 'includes/helpers.php')) {
                    require_once UPGRAM_PATH . 'includes/helpers.php';
                    if (function_exists('upgram_generate_minified_files')) {
                        upgram_generate_minified_files();
                    }
                }
            }
        }
    }
}
add_action('admin_init', 'upgram_generate_minified_after_settings_save', 20);

/**
 * Hook adicional para garantir geração após salvar configurações
 */
function upgram_generate_minified_on_settings_saved() {
    // Verificar se acabamos de salvar as configurações
    if (isset($_GET['settings-updated']) && $_GET['settings-updated'] === 'true') {
        $use_minified = get_option('upgram_use_minified_files', false);
        
        if ($use_minified) {
            // Verificar se os arquivos já existem
            $cache_dir = UPGRAM_PATH . 'cache';
            $script_min = $cache_dir . '/script.min.js';
            
            // Se não existir, gerar
            if (!file_exists($script_min)) {
                if (!function_exists('upgram_generate_minified_files')) {
                    require_once UPGRAM_PATH . 'includes/helpers.php';
                }
                
                if (function_exists('upgram_generate_minified_files')) {
                    try {
                        $generated = upgram_generate_minified_files();
                        if (!empty($generated)) {
                            error_log('Upgram: Arquivos minificados gerados após salvar: ' . implode(', ', $generated));
                        }
                    } catch (Exception $e) {
                        error_log('Upgram: Erro ao gerar arquivos após salvar: ' . $e->getMessage());
                    }
                }
            }
        }
    }
}
add_action('admin_notices', 'upgram_generate_minified_on_settings_saved', 1);

/**
 * Executar geração de arquivos minificados no shutdown
 */
function upgram_execute_minified_generation() {
    if (get_transient('upgram_generate_minified_files')) {
        delete_transient('upgram_generate_minified_files');
        
        // Garantir que helpers.php foi carregado
        if (!function_exists('upgram_generate_minified_files')) {
            require_once UPGRAM_PATH . 'includes/helpers.php';
        }
        
        if (function_exists('upgram_generate_minified_files')) {
            try {
                $generated = upgram_generate_minified_files();
                
                // Log para debug
                if (!empty($generated)) {
                    error_log('Upgram: Arquivos minificados gerados com sucesso: ' . implode(', ', $generated));
                } else {
                    error_log('Upgram: Nenhum arquivo foi gerado');
                }
            } catch (Exception $e) {
                error_log('Upgram: Erro ao gerar arquivos minificados: ' . $e->getMessage());
            }
        } else {
            error_log('Upgram: Função upgram_generate_minified_files não encontrada');
        }
    }
}
add_action('shutdown', 'upgram_execute_minified_generation', 99);

/**
 * OTIMIZAÇÃO PAGESPEED: Bloquear CSS desnecessário na página do produto
 * Remove CSS de temas, plugins e bibliotecas que não são usados pelo plugin Upgram
 */
function upgram_disable_unnecessary_css() {
    // Verificar se estamos em uma página de produto
    if (!is_product() && !is_singular('product')) {
        return;
    }
    
    global $post;
    
    // Verificar se o shortcode [upgram_product] está sendo usado
    $has_shortcode = $post && has_shortcode($post->post_content, 'upgram_product');
    
    if (!$has_shortcode) {
        return;
    }
    
    // Lista completa de CSS para desabilitar
    $css_to_disable = array(
        // CSS do tema Astra - WooCommerce Grid
        'woocommerce-grid',
        'astra-woocommerce-grid',
        'woocommerce-grid.min',
        'astra-woocommerce',
        'astra-woocommerce-css',
        
        // CSS do plugin Customer Reviews WooCommerce
        'cusrev-frontend',
        'customer-reviews-woocommerce-frontend',
        'cr-frontend',
        'cusrev',
        
        // CSS do Bootstrap (bloqueado - não necessário para o plugin Upgram)
        'bootstrap',
        'bootstrap-css',
        
        // CSS do WordPress Block Library (Gutenberg)
        'wp-block-library',
        'wp-block-library-css',
        'wp-block-library-theme',
        'wp-block-library-style',
        'global-styles',
        
        // Outros CSS comuns
        'woocommerce-blocktheme',
        'wc-block-style',
        'wc-blocks-style',
    );
    
    // Desabilitar cada CSS da lista
    foreach ($css_to_disable as $handle) {
        wp_dequeue_style($handle);
        wp_deregister_style($handle);
    }
    
    // MÉTODO ADICIONAL: Bloquear CSS por URL/pattern usando filtro de tags
    add_filter('style_loader_tag', 'upgram_filter_css_loader_tag', 10, 2);
    
    // Remover CSS inline do tema Astra
    add_filter('astra_dynamic_css', '__return_empty_string', 999);
    
    // Remover CSS inline de :root do tema via sobrescrita
    add_action('wp_head', function() {
        // Sobrescrever variáveis CSS do tema com valores mínimos
        echo '<style id="upgram-override-theme-css">';
        echo ':root {';
        echo '  --ast-post-nav-space: 0 !important;';
        echo '  --ast-container-default-xlg-padding: 0 !important;';
        echo '  --ast-container-default-lg-padding: 0 !important;';
        echo '  --ast-container-default-xl-padding: 0 !important;';
        echo '}';
        echo '</style>';
    }, 999);
}
add_action('wp_enqueue_scripts', 'upgram_disable_unnecessary_css', 999);

/**
 * OTIMIZAÇÃO PAGESPEED: Filtrar e remover links de CSS desnecessários usando style_loader_tag
 */
function upgram_filter_css_loader_tag($tag, $handle) {
    // Verificar se estamos em uma página de produto
    if (!is_product() && !is_singular('product')) {
        return $tag;
    }
    
    global $post;
    $has_shortcode = $post && has_shortcode($post->post_content, 'upgram_product');
    
    if (!$has_shortcode) {
        return $tag;
    }
    
    // Lista de handles de CSS para bloquear
    $css_handles_to_block = array(
        'woocommerce-grid',
        'astra-woocommerce-grid',
        'cusrev-frontend',
        'customer-reviews-woocommerce-frontend',
        'wp-block-library',
        'wp-block-library-css',
        'wp-block-library-theme',
        'bootstrap',
        'bootstrap-css',
    );
    
    // Se o handle está na lista de bloqueio, retornar string vazia
    if (in_array($handle, $css_handles_to_block)) {
        return '';
    }
    
    // Verificar se a URL do CSS contém padrões a serem bloqueados
    $css_url_patterns = array(
        'woocommerce-grid.min.css',
        'customer-reviews-woocommerce',
        'cusrev',
        'bootstrap.min.css',
        'wp-block-library',
        'block-library',
    );
    
    foreach ($css_url_patterns as $pattern) {
        if (strpos($tag, $pattern) !== false) {
            return '';
        }
    }
    
    return $tag;
}


/**
 * Sobrescrever template do produto WooCommerce quando opção estiver ativa
 * Remove a dependência do Elementor e do shortcode [upgram_product]
 */

/**
 * Desabilitar geração automática do schema Product do WooCommerce
 * quando o shortcode [upgram_product] está sendo usado
 * Isso evita duplicação do schema Product
 */
function upgram_disable_woocommerce_product_schema() {
    // Verificar se estamos em uma página de produto
    if (is_product() || is_singular('product')) {
        global $post;
        
        // Verificar se o shortcode está sendo usado
        $has_shortcode = $post && has_shortcode($post->post_content, 'upgram_product');
        
        if ($has_shortcode) {
            // Remover a geração automática do schema Product do WooCommerce
            // Remover de wp_footer (padrão do WooCommerce)
            if (class_exists('WooCommerce') && isset(WC()->structured_data)) {
                remove_action('wp_footer', array(WC()->structured_data, 'output_structured_data'), 10);
                // Também remover de wp_head caso esteja sendo usado em alguma versão
                remove_action('wp_head', array(WC()->structured_data, 'output_structured_data'), 10);
                
                // Remover breadcrumbs do WooCommerce se estiver gerando automaticamente
                // O WooCommerce pode gerar breadcrumbs através do structured_data
                add_filter('woocommerce_structured_data_breadcrumb', '__return_false', 999);
            }
        }
    }
}
add_action('wp', 'upgram_disable_woocommerce_product_schema', 5);

function upgram_scripts()
{
    wp_enqueue_style('google-fonts-manrope', 'https://fonts.googleapis.com/css2?family=Manrope:wght@200..800&display=swap', false);
    wp_enqueue_style('google-fonts-montserrat', 'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap', false);
    
    // Verificar se deve usar arquivos minificados
    $use_minified = upgram_use_minified_files();
    $style_file = $use_minified && file_exists(UPGRAM_PATH . 'cache/style.min.css') 
        ? 'cache/style.min.css' 
        : 'assets/css/style.css';
    wp_enqueue_style('upgram-style', plugins_url($style_file, __FILE__), array(), UPGRAM_VERSION);
    // OTIMIZAÇÃO PAGESPEED: Carregar orders.style.css apenas quando necessário (lazy loading)
    // O arquivo será carregado apenas em páginas que realmente precisam dele
    if (is_product() || is_shop() || is_cart() || is_checkout() || is_account_page()) {
        $orders_style_file = $use_minified && file_exists(UPGRAM_PATH . 'cache/orders.style.min.css')
            ? 'cache/orders.style.min.css'
            : 'assets/css/orders.style.css';
        wp_enqueue_style('upgram-orders-style', plugins_url($orders_style_file, __FILE__), array(), UPGRAM_VERSION);
    }
    wp_enqueue_style('bootstrap-icons', 'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css');
    
    // OTIMIZAÇÃO PAGESPEED: Bootstrap CSS será bloqueado na página do produto se não necessário
    // Verificar se estamos na página do produto antes de carregar Bootstrap
    $load_bootstrap = true;
    if (is_product() || is_singular('product')) {
        global $post;
        $has_shortcode = $post && has_shortcode($post->post_content, 'upgram_product');
        
        // Se o shortcode está sendo usado, podemos considerar não carregar Bootstrap
        // Mas vamos manter por enquanto para garantir compatibilidade com alguns componentes
        // Se necessário, descomente as linhas abaixo:
        // if ($has_shortcode) {
        //     $load_bootstrap = false;
        // }
    }
    
    if ($load_bootstrap) {
        wp_enqueue_style('bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css', array(), '5.0.2');
        wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js', array('jquery'), '5.0.2', true);
    }
    $script_file = $use_minified && file_exists(UPGRAM_PATH . 'cache/script.min.js')
        ? 'cache/script.min.js'
        : 'assets/js/script.js';
    wp_enqueue_script('upgram-script', plugins_url($script_file, __FILE__), array('jquery'), UPGRAM_VERSION, true);
    
    // Configurações do checkout
    $checkout_mode = get_option('upgram_checkout_mode', 'popup');
    $checkout_page_id = get_option('upgram_checkout_page_id', 0);
    $checkout_page_url = '';
    
    // Validar e obter URL da página de checkout
    if ($checkout_mode === 'page' && $checkout_page_id > 0) {
        $checkout_page_url = get_permalink($checkout_page_id);
        // Se não conseguir obter permalink, fazer fallback para popup
        if (!$checkout_page_url) {
            $checkout_mode = 'popup';
        }
    }
    
    wp_localize_script(
        'upgram-script',
        'ajax_object',
        ['ajax_url' => admin_url('admin-ajax.php'), 'security' => wp_create_nonce('upgram_nonce')]
    );
    
    // Adicionar configurações do checkout globalmente
    wp_add_inline_script('upgram-script', 'window.UpgramCheckoutConfig = ' . json_encode([
        'mode' => $checkout_mode,
        'checkoutPageUrl' => $checkout_page_url
    ]) . ';', 'before');
    wp_enqueue_script(
        'alpine-js',
        'https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js',
        [],
        null,
        true
    );

    // $image_url = plugins_url('/assets/images/arrow.svg', __FILE__);
    // $custom_css = "
    //         .upgram-input textarea::-webkit-resizer {
    //             background-image: url('{$image_url}');
    //         }
    //     ";
    // wp_add_inline_style('upgram-style', $custom_css);
}
add_action('wp_enqueue_scripts', 'upgram_scripts');

/**
 * OTIMIZAÇÃO PAGESPEED: Adicionar font-display: swap para fontes do WooCommerce
 */
function upgram_add_font_display_swap($tag, $handle) {
    // Verificar se é uma fonte (WooCommerce, Google Fonts, Font Awesome, Elementor, CDN)
    $is_font = (
        strpos($tag, 'fonts.googleapis.com') !== false || 
        strpos($tag, 'fonts.gstatic.com') !== false ||
        strpos($tag, 'woocommerce/assets/fonts') !== false ||
        strpos($tag, 'WooCommerce.woff') !== false ||
        strpos($tag, 'font-awesome') !== false ||
        strpos($tag, 'elementor/assets/lib/font-awesome') !== false ||
        strpos($tag, 'cdnjs.cloudflare.com/ajax/libs/font-awesome') !== false ||
        (strpos($tag, 'fa-') !== false && (strpos($tag, '.woff') !== false || strpos($tag, '.woff2') !== false)) ||
        (strpos($tag, '.woff') !== false || strpos($tag, '.woff2') !== false)
    );
    
    if ($is_font) {
        // Se já tem display=swap ou font-display, não precisa modificar
        if (strpos($tag, 'display=swap') === false && strpos($tag, 'font-display') === false) {
            // Para Google Fonts, adicionar display=swap na URL
            if (strpos($tag, 'fonts.googleapis.com') !== false || strpos($tag, 'fonts.gstatic.com') !== false) {
                $separator = strpos($tag, '?') !== false ? '&' : '?';
                $tag = str_replace('href="', 'href="' . $separator . 'display=swap&', $tag);
                return $tag;
            }
            
            // Para outras fontes (WooCommerce, Font Awesome, Elementor, CDN), injetar CSS e JavaScript
            // Isso garante que todas as fontes tenham font-display: swap
            add_action('wp_head', function() {
                static $added = false;
                if (!$added) {
                    echo '<style id="upgram-font-display-swap">';
                    // Regra CSS que força font-display: swap em todas as fontes
                    // Isso funciona interceptando as fontes carregadas
                    echo '/* Otimização: font-display: swap para todas as fontes */';
                    echo '@font-face { font-display: swap !important; }';
                    echo '</style>';
                    
                    // JavaScript para interceptar e modificar fontes carregadas dinamicamente
                    echo '<script id="upgram-font-display-swap-js">';
                    echo '(function() {';
                    echo '  // Interceptar fontes carregadas via @font-face';
                    echo '  const styleSheets = document.styleSheets;';
                    echo '  for (let i = 0; i < styleSheets.length; i++) {';
                    echo '    try {';
                    echo '      const rules = styleSheets[i].cssRules || styleSheets[i].rules;';
                    echo '      if (rules) {';
                    echo '        for (let j = 0; j < rules.length; j++) {';
                    echo '          if (rules[j].type === CSSRule.FONT_FACE_RULE) {';
                    echo '            if (!rules[j].style.getPropertyValue("font-display")) {';
                    echo '              rules[j].style.setProperty("font-display", "swap", "important");';
                    echo '            }';
                    echo '          }';
                    echo '        }';
                    echo '      }';
                    echo '    } catch(e) {}';
                    echo '  }';
                    echo '})();';
                    echo '</script>';
                    $added = true;
                }
            }, 1);
        }
    }
    return $tag;
}
add_filter('style_loader_tag', 'upgram_add_font_display_swap', 20, 2);

/**
 * OTIMIZAÇÃO PAGESPEED: Deferir scripts que bloqueiam renderização
 */
function upgram_defer_blocking_scripts($tag, $handle) {
    // Scripts que podem ser deferidos com segurança
    $scripts_to_defer = array(
        'litespeed-cache-instant-click',
    );
    
    // Verificar se é um script que deve ser deferido
    if (in_array($handle, $scripts_to_defer)) {
        // Se já tem defer ou async, não modificar
        if (strpos($tag, 'defer') === false && strpos($tag, 'async') === false) {
            $tag = str_replace(' src', ' defer src', $tag);
        }
    }
    
    // Para scripts carregados externamente por URL
    // instant_click pode ser deferido
    if (strpos($tag, 'instant_click.min.js') !== false) {
        if (strpos($tag, 'defer') === false && strpos($tag, 'async') === false) {
            $tag = str_replace(' src', ' defer src', $tag);
        }
    }
    
    // Para jQuery, verificar se está no footer antes de deferir
    // Nossos scripts estão no footer e dependem do jQuery
    if (strpos($tag, 'jquery.min.js') !== false || strpos($tag, 'jquery.js') !== false) {
        // Se o script está sendo carregado no footer (não no head), pode ser deferido
        // Verificar se não está sendo carregado antes do </head>
        if (strpos($tag, 'type=') !== false) {
            // Script está sendo carregado normalmente, verificar contexto
            // Se não tem 'before' no contexto, provavelmente está no footer
            // Adicionar defer apenas se não quebrar dependências
            // Como nossos scripts já estão no footer com dependência do jQuery,
            // podemos deferir jQuery se ele também estiver no footer
            if (strpos($tag, 'defer') === false && strpos($tag, 'async') === false) {
                // Adicionar defer de forma segura
                $tag = str_replace(' src', ' defer src', $tag);
            }
        }
    }
    
    return $tag;
}
add_filter('script_loader_tag', 'upgram_defer_blocking_scripts', 10, 2);

/**
 * Desabilitar sticky-add-to-cart nas páginas que usam o shortcode [upgram_product]
 * Isso previne erros quando o plugin procura por elementos que não existem
 */
function upgram_disable_sticky_add_to_cart() {
    // Verificar se estamos em uma página de produto
    if (is_product() || is_singular('product')) {
        global $post;
        
        // Verificar se o shortcode está sendo usado
        $has_shortcode = $post && has_shortcode($post->post_content, 'upgram_product');
        
        if ($has_shortcode) {
            // Tentar desabilitar diferentes variações do nome do script
            $script_handles = array(
                'woocommerce-sticky-add-to-cart',
                'sticky-add-to-cart',
                'wc-sticky-add-to-cart',
                'woocommerce_sticky_add_to_cart'
            );
            
            foreach ($script_handles as $handle) {
                wp_dequeue_script($handle);
                wp_deregister_script($handle);
            }
            
            // Adicionar proteção no HEAD antes de qualquer script ser carregado
            add_action('wp_head', function() {
                ?>
                <script type="text/javascript">
                (function() {
                    'use strict';
                    
                    // Proteção ANTES de qualquer script ser executado
                    // Interceptar e silenciar erros do sticky-add-to-cart
                    const originalError = window.onerror;
                    window.onerror = function(msg, url, line, col, error) {
                        if (msg && (
                            msg.toString().includes('offsetTop') || 
                            msg.toString().includes('sticky-add-to-cart') ||
                            msg.toString().includes('Cannot read properties of null') ||
                            (url && url.includes('sticky-add-to-cart'))
                        )) {
                            console.warn('Upgram: Erro do sticky-add-to-cart suprimido');
                            return true; // Suprimir o erro
                        }
                        // Chamar o handler original se existir
                        if (originalError) {
                            return originalError.apply(this, arguments);
                        }
                        return false;
                    };
                    
                    // Interceptar erros via addEventListener (captura phase)
                    window.addEventListener('error', function(e) {
                        if (e.message && (
                            e.message.includes('offsetTop') || 
                            e.message.includes('sticky-add-to-cart') ||
                            e.message.includes('Cannot read properties of null') ||
                            (e.filename && e.filename.includes('sticky-add-to-cart'))
                        )) {
                            e.preventDefault();
                            e.stopPropagation();
                            e.stopImmediatePropagation();
                            console.warn('Upgram: Erro do sticky-add-to-cart interceptado e suprimido');
                            return true;
                        }
                    }, true);
                    
                    // Interceptar promessas rejeitadas
                    window.addEventListener('unhandledrejection', function(e) {
                        if (e.reason && (
                            (e.reason.message && e.reason.message.includes('offsetTop')) ||
                            (e.reason.message && e.reason.message.includes('sticky-add-to-cart')) ||
                            (e.reason.message && e.reason.message.includes('Cannot read properties of null'))
                        )) {
                            e.preventDefault();
                            e.stopPropagation();
                            console.warn('Upgram: Promise rejection do sticky-add-to-cart suprimida');
                            return true;
                        }
                    }, true);
                    
                    // Criar elemento placeholder ANTES do DOM estar pronto
                    // Isso previne erros quando o script procura por elementos
                    if (document.readyState === 'loading') {
                        document.addEventListener('DOMContentLoaded', function() {
                            createStickyPlaceholder();
                        });
                    } else {
                        createStickyPlaceholder();
                    }
                    
                    function createStickyPlaceholder() {
                        try {
                            // Verificar se já existe
                            if (!document.querySelector('.sticky-add-to-cart')) {
                                const placeholder = document.createElement('div');
                                placeholder.className = 'sticky-add-to-cart';
                                placeholder.style.cssText = 'display: none !important; visibility: hidden !important; position: absolute !important; top: -9999px !important;';
                                placeholder.setAttribute('data-upgram-placeholder', 'true');
                                if (document.body) {
                                    document.body.appendChild(placeholder);
                                } else {
                                    // Se body ainda não existe, aguardar
                                    setTimeout(createStickyPlaceholder, 50);
                                }
                            }
                        } catch(e) {
                            // Ignorar erros silenciosamente
                        }
                    }
                    
                    // Proteção adicional: sobrescrever métodos que podem causar erros
                    // Executar após o DOM estar pronto
                    if (document.readyState === 'loading') {
                        document.addEventListener('DOMContentLoaded', protectStickyMethods);
                    } else {
                        protectStickyMethods();
                    }
                    
                    function protectStickyMethods() {
                        try {
                            // Interceptar querySelector para elementos sticky
                            const originalQuerySelector = document.querySelector;
                            const originalQuerySelectorAll = document.querySelectorAll;
                            
                            document.querySelector = function(selector) {
                                if (selector && (
                                    selector.includes('.sticky-add-to-cart') ||
                                    selector.includes('#sticky-add-to-cart')
                                )) {
                                    const placeholder = document.querySelector('[data-upgram-placeholder="true"]');
                                    if (placeholder) {
                                        return placeholder;
                                    }
                                }
                                return originalQuerySelector.apply(this, arguments);
                            };
                            
                            document.querySelectorAll = function(selector) {
                                if (selector && (
                                    selector.includes('.sticky-add-to-cart') ||
                                    selector.includes('#sticky-add-to-cart')
                                )) {
                                    const placeholder = document.querySelector('[data-upgram-placeholder="true"]');
                                    if (placeholder) {
                                        return [placeholder];
                                    }
                                    return [];
                                }
                                return originalQuerySelectorAll.apply(this, arguments);
                            };
                        } catch(e) {
                            // Ignorar erros silenciosamente
                        }
                    }
                })();
                </script>
                <?php
            }, 1); // Prioridade 1 para executar ANTES de outros scripts
            
            // Proteção adicional no footer (backup)
            add_action('wp_footer', function() {
                ?>
                <script type="text/javascript">
                (function() {
                    // Backup: garantir que erros sejam suprimidos mesmo se algo passar
                    if (window.onerror) {
                        const existingHandler = window.onerror;
                        window.onerror = function(msg, url, line, col, error) {
                            if (msg && (
                                msg.toString().includes('offsetTop') || 
                                msg.toString().includes('sticky-add-to-cart') ||
                                msg.toString().includes('Cannot read properties of null') ||
                                (url && url.includes('sticky-add-to-cart'))
                            )) {
                                return true;
                            }
                            return existingHandler ? existingHandler.apply(this, arguments) : false;
                        };
                    }
                })();
                </script>
                <?php
            }, 999);
        }
    }
}
add_action('wp_enqueue_scripts', 'upgram_disable_sticky_add_to_cart', 999);

function upgram_admin_scripts()
{
    wp_enqueue_script(
        'alpine-js',
        'https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js',
        [],
        null,
        true
    );
}
add_action('admin_enqueue_scripts', 'upgram_admin_scripts');

add_action('init', 'start_session', 1);
function start_session()
{
    if (!session_id() && !headers_sent()) {
        session_start();
    }
}

// Agendar verificação de licença ao ativar plugin
register_activation_hook(__FILE__, function() {
    // Usar transiente para garantir que seja agendado após o carregamento completo
    set_transient('upgram_schedule_license_check', true, 60);
});

// Limpar agendamento ao desativar plugin
register_deactivation_hook(__FILE__, function() {
    // Limpar agendamento mesmo se classe não estiver carregada
    if (function_exists('as_unschedule_all_actions')) {
        as_unschedule_all_actions('upgram_check_license_status_recurring');
    }
    wp_clear_scheduled_hook('upgram_check_license_status_recurring');
    // Limpar também validação horária
    wp_clear_scheduled_hook('upgram_hourly_license_validation');
});
